package zio.aws.elasticloadbalancingv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.Marker
import scala.jdk.CollectionConverters._
final case class DescribeRulesResponse(
    rules: Option[Iterable[zio.aws.elasticloadbalancingv2.model.Rule]] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse = {
    import DescribeRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse
      .wrap(buildAwsValue())
}
object DescribeRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse =
      zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def rules: Option[List[zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly]]
    def nextMarker: Option[Marker]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse
  ) extends zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse.ReadOnly {
    override val rules
        : Option[List[zio.aws.elasticloadbalancingv2.model.Rule.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancingv2.model.Rule.wrap(item)
          }.toList
        )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.Marker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse
  ): zio.aws.elasticloadbalancingv2.model.DescribeRulesResponse.ReadOnly =
    new Wrapper(impl)
}
