package zio.aws.elasticloadbalancingv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancingv2.model.primitives.{
  CipherPriority,
  CipherName
}
import scala.jdk.CollectionConverters._
final case class Cipher(
    name: Option[CipherName] = None,
    priority: Option[CipherPriority] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher = {
    import Cipher.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher
      .builder()
      .optionallyWith(
        name.map(value => CipherName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        priority.map(value => CipherPriority.unwrap(value): Integer)
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancingv2.model.Cipher.ReadOnly =
    zio.aws.elasticloadbalancingv2.model.Cipher.wrap(buildAwsValue())
}
object Cipher {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancingv2.model.Cipher =
      zio.aws.elasticloadbalancingv2.model
        .Cipher(name.map(value => value), priority.map(value => value))
    def name: Option[CipherName]
    def priority: Option[CipherPriority]
    def getName: ZIO[Any, AwsError, CipherName] =
      AwsError.unwrapOptionField("name", name)
    def getPriority: ZIO[Any, AwsError, CipherPriority] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher
  ) extends zio.aws.elasticloadbalancingv2.model.Cipher.ReadOnly {
    override val name: Option[CipherName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.CipherName(value)
      )
    override val priority: Option[CipherPriority] = scala
      .Option(impl.priority())
      .map(value =>
        zio.aws.elasticloadbalancingv2.model.primitives.CipherPriority(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher
  ): zio.aws.elasticloadbalancingv2.model.Cipher.ReadOnly = new Wrapper(impl)
}
