package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableAvailabilityZonesForLoadBalancerResponse(
    availabilityZones: Optional[Iterable[AvailabilityZone]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse = {
    import DisableAvailabilityZonesForLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            AvailabilityZone.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse
      .wrap(buildAwsValue())
}
object DisableAvailabilityZonesForLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse =
      zio.aws.elasticloadbalancing.model
        .DisableAvailabilityZonesForLoadBalancerResponse(
          availabilityZones.map(value => value)
        )
    def availabilityZones: Optional[List[AvailabilityZone]]
    def getAvailabilityZones: ZIO[Any, AwsError, List[AvailabilityZone]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse
  ) extends zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse.ReadOnly {
    override val availabilityZones: Optional[List[AvailabilityZone]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse
  ): zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse.ReadOnly =
    new Wrapper(impl)
}
