package zio.aws.elasticloadbalancing.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancing.model.primitives.{PolicyName, InstancePort}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class BackendServerDescription(
    instancePort: Optional[InstancePort] = Optional.Absent,
    policyNames: Optional[Iterable[PolicyName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescription = {
    import BackendServerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescription
      .builder()
      .optionallyWith(
        instancePort.map(value => InstancePort.unwrap(value): Integer)
      )(_.instancePort)
      .optionallyWith(
        policyNames.map(value =>
          value.map { item =>
            PolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNames)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.BackendServerDescription.ReadOnly =
    zio.aws.elasticloadbalancing.model.BackendServerDescription
      .wrap(buildAwsValue())
}
object BackendServerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.BackendServerDescription =
      zio.aws.elasticloadbalancing.model.BackendServerDescription(
        instancePort.map(value => value),
        policyNames.map(value => value)
      )
    def instancePort: Optional[InstancePort]
    def policyNames: Optional[List[PolicyName]]
    def getInstancePort: ZIO[Any, AwsError, InstancePort] =
      AwsError.unwrapOptionField("instancePort", instancePort)
    def getPolicyNames: ZIO[Any, AwsError, List[PolicyName]] =
      AwsError.unwrapOptionField("policyNames", policyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescription
  ) extends zio.aws.elasticloadbalancing.model.BackendServerDescription.ReadOnly {
    override val instancePort: Optional[InstancePort] = zio.aws.core.internal
      .optionalFromNullable(impl.instancePort())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.InstancePort(value)
      )
    override val policyNames: Optional[List[PolicyName]] = zio.aws.core.internal
      .optionalFromNullable(impl.policyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.PolicyName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescription
  ): zio.aws.elasticloadbalancing.model.BackendServerDescription.ReadOnly =
    new Wrapper(impl)
}
