package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  PolicyTypeName,
  PolicyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PolicyDescription(
    policyName: Optional[PolicyName] = Optional.Absent,
    policyTypeName: Optional[PolicyTypeName] = Optional.Absent,
    policyAttributeDescriptions: Optional[
      Iterable[zio.aws.elasticloadbalancing.model.PolicyAttributeDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescription = {
    import PolicyDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescription
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyTypeName.map(value =>
          PolicyTypeName.unwrap(value): java.lang.String
        )
      )(_.policyTypeName)
      .optionallyWith(
        policyAttributeDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyAttributeDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.PolicyDescription.ReadOnly =
    zio.aws.elasticloadbalancing.model.PolicyDescription.wrap(buildAwsValue())
}
object PolicyDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.PolicyDescription =
      zio.aws.elasticloadbalancing.model.PolicyDescription(
        policyName.map(value => value),
        policyTypeName.map(value => value),
        policyAttributeDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyName: Optional[PolicyName]
    def policyTypeName: Optional[PolicyTypeName]
    def policyAttributeDescriptions: Optional[List[
      zio.aws.elasticloadbalancing.model.PolicyAttributeDescription.ReadOnly
    ]]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyTypeName: ZIO[Any, AwsError, PolicyTypeName] =
      AwsError.unwrapOptionField("policyTypeName", policyTypeName)
    def getPolicyAttributeDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.PolicyAttributeDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "policyAttributeDescriptions",
      policyAttributeDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescription
  ) extends zio.aws.elasticloadbalancing.model.PolicyDescription.ReadOnly {
    override val policyName: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.PolicyName(value)
      )
    override val policyTypeName: Optional[PolicyTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyTypeName())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives.PolicyTypeName(value)
        )
    override val policyAttributeDescriptions: Optional[List[
      zio.aws.elasticloadbalancing.model.PolicyAttributeDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.policyAttributeDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.PolicyAttributeDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyDescription
  ): zio.aws.elasticloadbalancing.model.PolicyDescription.ReadOnly =
    new Wrapper(impl)
}
