package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  Description,
  PolicyTypeName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PolicyTypeDescription(
    policyTypeName: Optional[PolicyTypeName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    policyAttributeTypeDescriptions: Optional[Iterable[
      zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescription = {
    import PolicyTypeDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescription
      .builder()
      .optionallyWith(
        policyTypeName.map(value =>
          PolicyTypeName.unwrap(value): java.lang.String
        )
      )(_.policyTypeName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        policyAttributeTypeDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyAttributeTypeDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.PolicyTypeDescription.ReadOnly =
    zio.aws.elasticloadbalancing.model.PolicyTypeDescription
      .wrap(buildAwsValue())
}
object PolicyTypeDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.PolicyTypeDescription =
      zio.aws.elasticloadbalancing.model.PolicyTypeDescription(
        policyTypeName.map(value => value),
        description.map(value => value),
        policyAttributeTypeDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyTypeName: Optional[PolicyTypeName]
    def description: Optional[Description]
    def policyAttributeTypeDescriptions: Optional[List[
      zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription.ReadOnly
    ]]
    def getPolicyTypeName: ZIO[Any, AwsError, PolicyTypeName] =
      AwsError.unwrapOptionField("policyTypeName", policyTypeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPolicyAttributeTypeDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "policyAttributeTypeDescriptions",
      policyAttributeTypeDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescription
  ) extends zio.aws.elasticloadbalancing.model.PolicyTypeDescription.ReadOnly {
    override val policyTypeName: Optional[PolicyTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyTypeName())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives.PolicyTypeName(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.Description(value)
      )
    override val policyAttributeTypeDescriptions: Optional[List[
      zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.policyAttributeTypeDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescription
  ): zio.aws.elasticloadbalancing.model.PolicyTypeDescription.ReadOnly =
    new Wrapper(impl)
}
