package zio.aws.elasticloadbalancing.model
import java.lang.Integer
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  PolicyName,
  AccessPointPort,
  AccessPointName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetLoadBalancerPoliciesOfListenerRequest(
    loadBalancerName: AccessPointName,
    loadBalancerPort: AccessPointPort,
    policyNames: Iterable[PolicyName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest = {
    import SetLoadBalancerPoliciesOfListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .loadBalancerPort(AccessPointPort.unwrap(loadBalancerPort): Integer)
      .policyNames(policyNames.map { item =>
        PolicyName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest
      .wrap(buildAwsValue())
}
object SetLoadBalancerPoliciesOfListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest =
      zio.aws.elasticloadbalancing.model
        .SetLoadBalancerPoliciesOfListenerRequest(
          loadBalancerName,
          loadBalancerPort,
          policyNames
        )
    def loadBalancerName: AccessPointName
    def loadBalancerPort: AccessPointPort
    def policyNames: List[PolicyName]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getLoadBalancerPort: ZIO[Any, Nothing, AccessPointPort] =
      ZIO.succeed(loadBalancerPort)
    def getPolicyNames: ZIO[Any, Nothing, List[PolicyName]] =
      ZIO.succeed(policyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest
  ) extends zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val loadBalancerPort: AccessPointPort =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointPort(impl.loadBalancerPort())
    override val policyNames: List[PolicyName] = impl
      .policyNames()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.PolicyName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest
  ): zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest.ReadOnly =
    new Wrapper(impl)
}
