package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTagsResponse(
    tagDescriptions: Optional[
      Iterable[zio.aws.elasticloadbalancing.model.TagDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse = {
    import DescribeTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse
      .builder()
      .optionallyWith(
        tagDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeTagsResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeTagsResponse
      .wrap(buildAwsValue())
}
object DescribeTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.DescribeTagsResponse =
      zio.aws.elasticloadbalancing.model.DescribeTagsResponse(
        tagDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tagDescriptions: Optional[
      List[zio.aws.elasticloadbalancing.model.TagDescription.ReadOnly]
    ]
    def getTagDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.TagDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("tagDescriptions", tagDescriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse
  ) extends zio.aws.elasticloadbalancing.model.DescribeTagsResponse.ReadOnly {
    override val tagDescriptions: Optional[
      List[zio.aws.elasticloadbalancing.model.TagDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tagDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.TagDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsResponse
  ): zio.aws.elasticloadbalancing.model.DescribeTagsResponse.ReadOnly =
    new Wrapper(impl)
}
