package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  SecurityGroupId,
  AccessPointName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplySecurityGroupsToLoadBalancerRequest(
    loadBalancerName: AccessPointName,
    securityGroups: Iterable[SecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest = {
    import ApplySecurityGroupsToLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .securityGroups(securityGroups.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest
      .wrap(buildAwsValue())
}
object ApplySecurityGroupsToLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest =
      zio.aws.elasticloadbalancing.model
        .ApplySecurityGroupsToLoadBalancerRequest(
          loadBalancerName,
          securityGroups
        )
    def loadBalancerName: AccessPointName
    def securityGroups: List[SecurityGroupId]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getSecurityGroups: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest
  ) extends zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val securityGroups: List[SecurityGroupId] = impl
      .securityGroups()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.SecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest
  ): zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
