package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  PolicyName,
  AccessPointName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancerPoliciesRequest(
    loadBalancerName: Optional[AccessPointName] = Optional.Absent,
    policyNames: Optional[Iterable[PolicyName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest = {
    import DescribeLoadBalancerPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest
      .builder()
      .optionallyWith(
        loadBalancerName.map(value =>
          AccessPointName.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(
        policyNames.map(value =>
          value.map { item =>
            PolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNames)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest
      .wrap(buildAwsValue())
}
object DescribeLoadBalancerPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest =
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest(
        loadBalancerName.map(value => value),
        policyNames.map(value => value)
      )
    def loadBalancerName: Optional[AccessPointName]
    def policyNames: Optional[List[PolicyName]]
    def getLoadBalancerName: ZIO[Any, AwsError, AccessPointName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getPolicyNames: ZIO[Any, AwsError, List[PolicyName]] =
      AwsError.unwrapOptionField("policyNames", policyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest
  ) extends zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest.ReadOnly {
    override val loadBalancerName: Optional[AccessPointName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerName())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives.AccessPointName(value)
        )
    override val policyNames: Optional[List[PolicyName]] = zio.aws.core.internal
      .optionalFromNullable(impl.policyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.PolicyName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest
  ): zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
