package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.Marker
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAccountLimitsResponse(
    limits: Optional[Iterable[zio.aws.elasticloadbalancing.model.Limit]] =
      Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse = {
    import DescribeAccountLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
      .builder()
      .optionallyWith(
        limits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.limits)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse
      .wrap(buildAwsValue())
}
object DescribeAccountLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse =
      zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse(
        limits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def limits
        : Optional[List[zio.aws.elasticloadbalancing.model.Limit.ReadOnly]]
    def nextMarker: Optional[Marker]
    def getLimits: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.Limit.ReadOnly
    ]] = AwsError.unwrapOptionField("limits", limits)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
  ) extends zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly {
    override val limits
        : Optional[List[zio.aws.elasticloadbalancing.model.Limit.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.Limit.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
  ): zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
