package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  SecurityGroupName,
  SecurityGroupOwnerAlias
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SourceSecurityGroup(
    ownerAlias: Optional[SecurityGroupOwnerAlias] = Optional.Absent,
    groupName: Optional[SecurityGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.SourceSecurityGroup = {
    import SourceSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.SourceSecurityGroup
      .builder()
      .optionallyWith(
        ownerAlias.map(value =>
          SecurityGroupOwnerAlias.unwrap(value): java.lang.String
        )
      )(_.ownerAlias)
      .optionallyWith(
        groupName.map(value =>
          SecurityGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.SourceSecurityGroup.ReadOnly =
    zio.aws.elasticloadbalancing.model.SourceSecurityGroup.wrap(buildAwsValue())
}
object SourceSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.SourceSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.SourceSecurityGroup =
      zio.aws.elasticloadbalancing.model.SourceSecurityGroup(
        ownerAlias.map(value => value),
        groupName.map(value => value)
      )
    def ownerAlias: Optional[SecurityGroupOwnerAlias]
    def groupName: Optional[SecurityGroupName]
    def getOwnerAlias: ZIO[Any, AwsError, SecurityGroupOwnerAlias] =
      AwsError.unwrapOptionField("ownerAlias", ownerAlias)
    def getGroupName: ZIO[Any, AwsError, SecurityGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.SourceSecurityGroup
  ) extends zio.aws.elasticloadbalancing.model.SourceSecurityGroup.ReadOnly {
    override val ownerAlias: Optional[SecurityGroupOwnerAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerAlias())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives
            .SecurityGroupOwnerAlias(value)
        )
    override val groupName: Optional[SecurityGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.SecurityGroupName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.SourceSecurityGroup
  ): zio.aws.elasticloadbalancing.model.SourceSecurityGroup.ReadOnly =
    new Wrapper(impl)
}
