package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  AttributeType,
  AttributeName,
  Cardinality,
  DefaultValue,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PolicyAttributeTypeDescription(
    attributeName: Optional[AttributeName] = Optional.Absent,
    attributeType: Optional[AttributeType] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    defaultValue: Optional[DefaultValue] = Optional.Absent,
    cardinality: Optional[Cardinality] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription = {
    import PolicyAttributeTypeDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription
      .builder()
      .optionallyWith(
        attributeName.map(value =>
          AttributeName.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        attributeType.map(value =>
          AttributeType.unwrap(value): java.lang.String
        )
      )(_.attributeType)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        defaultValue.map(value => DefaultValue.unwrap(value): java.lang.String)
      )(_.defaultValue)
      .optionallyWith(
        cardinality.map(value => Cardinality.unwrap(value): java.lang.String)
      )(_.cardinality)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription.ReadOnly =
    zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription
      .wrap(buildAwsValue())
}
object PolicyAttributeTypeDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription =
      zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription(
        attributeName.map(value => value),
        attributeType.map(value => value),
        description.map(value => value),
        defaultValue.map(value => value),
        cardinality.map(value => value)
      )
    def attributeName: Optional[AttributeName]
    def attributeType: Optional[AttributeType]
    def description: Optional[Description]
    def defaultValue: Optional[DefaultValue]
    def cardinality: Optional[Cardinality]
    def getAttributeName: ZIO[Any, AwsError, AttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeType: ZIO[Any, AwsError, AttributeType] =
      AwsError.unwrapOptionField("attributeType", attributeType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultValue: ZIO[Any, AwsError, DefaultValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getCardinality: ZIO[Any, AwsError, Cardinality] =
      AwsError.unwrapOptionField("cardinality", cardinality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription
  ) extends zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription.ReadOnly {
    override val attributeName: Optional[AttributeName] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.AttributeName(value)
      )
    override val attributeType: Optional[AttributeType] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeType())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.AttributeType(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.Description(value)
      )
    override val defaultValue: Optional[DefaultValue] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.DefaultValue(value)
      )
    override val cardinality: Optional[Cardinality] = zio.aws.core.internal
      .optionalFromNullable(impl.cardinality())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.Cardinality(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription
  ): zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription.ReadOnly =
    new Wrapper(impl)
}
