package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  SubnetId,
  AccessPointName,
  SecurityGroupId,
  LoadBalancerScheme,
  AvailabilityZone
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLoadBalancerRequest(
    loadBalancerName: AccessPointName,
    listeners: Iterable[zio.aws.elasticloadbalancing.model.Listener],
    availabilityZones: Optional[Iterable[AvailabilityZone]] = Optional.Absent,
    subnets: Optional[Iterable[SubnetId]] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    scheme: Optional[LoadBalancerScheme] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticloadbalancing.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest = {
    import CreateLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .listeners(listeners.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            AvailabilityZone.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        scheme.map(value => LoadBalancerScheme.unwrap(value): java.lang.String)
      )(_.scheme)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.CreateLoadBalancerRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerRequest
      .wrap(buildAwsValue())
}
object CreateLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.CreateLoadBalancerRequest =
      zio.aws.elasticloadbalancing.model.CreateLoadBalancerRequest(
        loadBalancerName,
        listeners.map { item =>
          item.asEditable
        },
        availabilityZones.map(value => value),
        subnets.map(value => value),
        securityGroups.map(value => value),
        scheme.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def loadBalancerName: AccessPointName
    def listeners: List[zio.aws.elasticloadbalancing.model.Listener.ReadOnly]
    def availabilityZones: Optional[List[AvailabilityZone]]
    def subnets: Optional[List[SubnetId]]
    def securityGroups: Optional[List[SecurityGroupId]]
    def scheme: Optional[LoadBalancerScheme]
    def tags: Optional[List[zio.aws.elasticloadbalancing.model.Tag.ReadOnly]]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getListeners: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancing.model.Listener.ReadOnly
    ]] = ZIO.succeed(listeners)
    def getAvailabilityZones: ZIO[Any, AwsError, List[AvailabilityZone]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSubnets: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getScheme: ZIO[Any, AwsError, LoadBalancerScheme] =
      AwsError.unwrapOptionField("scheme", scheme)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest
  ) extends zio.aws.elasticloadbalancing.model.CreateLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val listeners
        : List[zio.aws.elasticloadbalancing.model.Listener.ReadOnly] = impl
      .listeners()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.Listener.wrap(item)
      }
      .toList
    override val availabilityZones: Optional[List[AvailabilityZone]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone(item)
          }.toList
        )
    override val subnets: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val scheme: Optional[LoadBalancerScheme] = zio.aws.core.internal
      .optionalFromNullable(impl.scheme())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.LoadBalancerScheme(value)
      )
    override val tags
        : Optional[List[zio.aws.elasticloadbalancing.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest
  ): zio.aws.elasticloadbalancing.model.CreateLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
