package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.PolicyName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListenerDescription(
    listener: Optional[zio.aws.elasticloadbalancing.model.Listener] =
      Optional.Absent,
    policyNames: Optional[Iterable[PolicyName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescription = {
    import ListenerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescription
      .builder()
      .optionallyWith(listener.map(value => value.buildAwsValue()))(_.listener)
      .optionallyWith(
        policyNames.map(value =>
          value.map { item =>
            PolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNames)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.ListenerDescription.ReadOnly =
    zio.aws.elasticloadbalancing.model.ListenerDescription.wrap(buildAwsValue())
}
object ListenerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.ListenerDescription =
      zio.aws.elasticloadbalancing.model.ListenerDescription(
        listener.map(value => value.asEditable),
        policyNames.map(value => value)
      )
    def listener: Optional[zio.aws.elasticloadbalancing.model.Listener.ReadOnly]
    def policyNames: Optional[List[PolicyName]]
    def getListener: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.Listener.ReadOnly
    ] = AwsError.unwrapOptionField("listener", listener)
    def getPolicyNames: ZIO[Any, AwsError, List[PolicyName]] =
      AwsError.unwrapOptionField("policyNames", policyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescription
  ) extends zio.aws.elasticloadbalancing.model.ListenerDescription.ReadOnly {
    override val listener
        : Optional[zio.aws.elasticloadbalancing.model.Listener.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listener())
        .map(value => zio.aws.elasticloadbalancing.model.Listener.wrap(value))
    override val policyNames: Optional[List[PolicyName]] = zio.aws.core.internal
      .optionalFromNullable(impl.policyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.PolicyName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescription
  ): zio.aws.elasticloadbalancing.model.ListenerDescription.ReadOnly =
    new Wrapper(impl)
}
