package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.PolicyTypeName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancerPolicyTypesRequest(
    policyTypeNames: Optional[Iterable[PolicyTypeName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest = {
    import DescribeLoadBalancerPolicyTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest
      .builder()
      .optionallyWith(
        policyTypeNames.map(value =>
          value.map { item =>
            PolicyTypeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyTypeNames)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest
      .wrap(buildAwsValue())
}
object DescribeLoadBalancerPolicyTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest =
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest(
        policyTypeNames.map(value => value)
      )
    def policyTypeNames: Optional[List[PolicyTypeName]]
    def getPolicyTypeNames: ZIO[Any, AwsError, List[PolicyTypeName]] =
      AwsError.unwrapOptionField("policyTypeNames", policyTypeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest
  ) extends zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest.ReadOnly {
    override val policyTypeNames: Optional[List[PolicyTypeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyTypeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.primitives.PolicyTypeName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest
  ): zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest.ReadOnly =
    new Wrapper(impl)
}
