package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  AvailabilityZone,
  AccessPointName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableAvailabilityZonesForLoadBalancerRequest(
    loadBalancerName: AccessPointName,
    availabilityZones: Iterable[AvailabilityZone]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest = {
    import EnableAvailabilityZonesForLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .availabilityZones(availabilityZones.map { item =>
        AvailabilityZone.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest
      .wrap(buildAwsValue())
}
object EnableAvailabilityZonesForLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest =
      zio.aws.elasticloadbalancing.model
        .EnableAvailabilityZonesForLoadBalancerRequest(
          loadBalancerName,
          availabilityZones
        )
    def loadBalancerName: AccessPointName
    def availabilityZones: List[AvailabilityZone]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getAvailabilityZones: ZIO[Any, Nothing, List[AvailabilityZone]] =
      ZIO.succeed(availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest
  ) extends zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val availabilityZones: List[AvailabilityZone] = impl
      .availabilityZones()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest
  ): zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
