package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceHealthRequest(
    loadBalancerName: AccessPointName,
    instances: Optional[Iterable[zio.aws.elasticloadbalancing.model.Instance]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest = {
    import DescribeInstanceHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeInstanceHealthRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeInstanceHealthRequest
      .wrap(buildAwsValue())
}
object DescribeInstanceHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeInstanceHealthRequest =
      zio.aws.elasticloadbalancing.model.DescribeInstanceHealthRequest(
        loadBalancerName,
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def loadBalancerName: AccessPointName
    def instances
        : Optional[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest
  ) extends zio.aws.elasticloadbalancing.model.DescribeInstanceHealthRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val instances
        : Optional[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.Instance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest
  ): zio.aws.elasticloadbalancing.model.DescribeInstanceHealthRequest.ReadOnly =
    new Wrapper(impl)
}
