package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancerAttributesResponse(
    loadBalancerAttributes: Optional[
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse = {
    import DescribeLoadBalancerAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse
      .builder()
      .optionallyWith(
        loadBalancerAttributes.map(value => value.buildAwsValue())
      )(_.loadBalancerAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeLoadBalancerAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse =
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse(
        loadBalancerAttributes.map(value => value.asEditable)
      )
    def loadBalancerAttributes: Optional[
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly
    ]
    def getLoadBalancerAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "loadBalancerAttributes",
      loadBalancerAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse
  ) extends zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse.ReadOnly {
    override val loadBalancerAttributes: Optional[
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerAttributes())
      .map(value =>
        zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse
  ): zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
