package zio.aws.elasticloadbalancing.model
import java.lang.Integer
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  AccessPointPort,
  AccessPointName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLoadBalancerListenersRequest(
    loadBalancerName: AccessPointName,
    loadBalancerPorts: Iterable[AccessPointPort]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest = {
    import DeleteLoadBalancerListenersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .loadBalancerPorts(loadBalancerPorts.map { item =>
        AccessPointPort.unwrap(item): Integer
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest
      .wrap(buildAwsValue())
}
object DeleteLoadBalancerListenersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest =
      zio.aws.elasticloadbalancing.model
        .DeleteLoadBalancerListenersRequest(loadBalancerName, loadBalancerPorts)
    def loadBalancerName: AccessPointName
    def loadBalancerPorts: List[AccessPointPort]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getLoadBalancerPorts: ZIO[Any, Nothing, List[AccessPointPort]] =
      ZIO.succeed(loadBalancerPorts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest
  ) extends zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val loadBalancerPorts: List[AccessPointPort] = impl
      .loadBalancerPorts()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.AccessPointPort(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest
  ): zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest.ReadOnly =
    new Wrapper(impl)
}
