package zio.aws.elasticloadbalancing.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancing.model.primitives.{
  AccessLogPrefix,
  AccessLogInterval,
  S3BucketName,
  AccessLogEnabled
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AccessLog(
    enabled: AccessLogEnabled,
    s3BucketName: Optional[S3BucketName] = Optional.Absent,
    emitInterval: Optional[AccessLogInterval] = Optional.Absent,
    s3BucketPrefix: Optional[AccessLogPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog = {
    import AccessLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog
      .builder()
      .enabled(AccessLogEnabled.unwrap(enabled): java.lang.Boolean)
      .optionallyWith(
        s3BucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.s3BucketName)
      .optionallyWith(
        emitInterval.map(value => AccessLogInterval.unwrap(value): Integer)
      )(_.emitInterval)
      .optionallyWith(
        s3BucketPrefix.map(value =>
          AccessLogPrefix.unwrap(value): java.lang.String
        )
      )(_.s3BucketPrefix)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.AccessLog.ReadOnly =
    zio.aws.elasticloadbalancing.model.AccessLog.wrap(buildAwsValue())
}
object AccessLog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.AccessLog =
      zio.aws.elasticloadbalancing.model.AccessLog(
        enabled,
        s3BucketName.map(value => value),
        emitInterval.map(value => value),
        s3BucketPrefix.map(value => value)
      )
    def enabled: AccessLogEnabled
    def s3BucketName: Optional[S3BucketName]
    def emitInterval: Optional[AccessLogInterval]
    def s3BucketPrefix: Optional[AccessLogPrefix]
    def getEnabled: ZIO[Any, Nothing, AccessLogEnabled] = ZIO.succeed(enabled)
    def getS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getEmitInterval: ZIO[Any, AwsError, AccessLogInterval] =
      AwsError.unwrapOptionField("emitInterval", emitInterval)
    def getS3BucketPrefix: ZIO[Any, AwsError, AccessLogPrefix] =
      AwsError.unwrapOptionField("s3BucketPrefix", s3BucketPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog
  ) extends zio.aws.elasticloadbalancing.model.AccessLog.ReadOnly {
    override val enabled: AccessLogEnabled =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessLogEnabled(impl.enabled())
    override val s3BucketName: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.S3BucketName(value)
      )
    override val emitInterval: Optional[AccessLogInterval] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emitInterval())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives.AccessLogInterval(value)
        )
    override val s3BucketPrefix: Optional[AccessLogPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BucketPrefix())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives.AccessLogPrefix(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog
  ): zio.aws.elasticloadbalancing.model.AccessLog.ReadOnly = new Wrapper(impl)
}
