package zio.aws.elasticloadbalancing.model
import java.lang.Integer
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  HealthCheckInterval,
  HealthCheckTarget,
  HealthCheckTimeout,
  HealthyThreshold,
  UnhealthyThreshold
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HealthCheck(
    target: HealthCheckTarget,
    interval: HealthCheckInterval,
    timeout: HealthCheckTimeout,
    unhealthyThreshold: UnhealthyThreshold,
    healthyThreshold: HealthyThreshold
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck = {
    import HealthCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck
      .builder()
      .target(HealthCheckTarget.unwrap(target): java.lang.String)
      .interval(HealthCheckInterval.unwrap(interval): Integer)
      .timeout(HealthCheckTimeout.unwrap(timeout): Integer)
      .unhealthyThreshold(
        UnhealthyThreshold.unwrap(unhealthyThreshold): Integer
      )
      .healthyThreshold(HealthyThreshold.unwrap(healthyThreshold): Integer)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly =
    zio.aws.elasticloadbalancing.model.HealthCheck.wrap(buildAwsValue())
}
object HealthCheck {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.HealthCheck =
      zio.aws.elasticloadbalancing.model.HealthCheck(
        target,
        interval,
        timeout,
        unhealthyThreshold,
        healthyThreshold
      )
    def target: HealthCheckTarget
    def interval: HealthCheckInterval
    def timeout: HealthCheckTimeout
    def unhealthyThreshold: UnhealthyThreshold
    def healthyThreshold: HealthyThreshold
    def getTarget: ZIO[Any, Nothing, HealthCheckTarget] = ZIO.succeed(target)
    def getInterval: ZIO[Any, Nothing, HealthCheckInterval] =
      ZIO.succeed(interval)
    def getTimeout: ZIO[Any, Nothing, HealthCheckTimeout] = ZIO.succeed(timeout)
    def getUnhealthyThreshold: ZIO[Any, Nothing, UnhealthyThreshold] =
      ZIO.succeed(unhealthyThreshold)
    def getHealthyThreshold: ZIO[Any, Nothing, HealthyThreshold] =
      ZIO.succeed(healthyThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck
  ) extends zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly {
    override val target: HealthCheckTarget =
      zio.aws.elasticloadbalancing.model.primitives
        .HealthCheckTarget(impl.target())
    override val interval: HealthCheckInterval =
      zio.aws.elasticloadbalancing.model.primitives
        .HealthCheckInterval(impl.interval())
    override val timeout: HealthCheckTimeout =
      zio.aws.elasticloadbalancing.model.primitives
        .HealthCheckTimeout(impl.timeout())
    override val unhealthyThreshold: UnhealthyThreshold =
      zio.aws.elasticloadbalancing.model.primitives
        .UnhealthyThreshold(impl.unhealthyThreshold())
    override val healthyThreshold: HealthyThreshold =
      zio.aws.elasticloadbalancing.model.primitives
        .HealthyThreshold(impl.healthyThreshold())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck
  ): zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly = new Wrapper(impl)
}
