package zio.aws.elasticloadbalancing
import zio.prelude.Subtype
import zio.aws.elasticloadbalancing.model.primitives.{
  SubnetId,
  AccessPointName,
  SecurityGroupId,
  PolicyName,
  PolicyTypeName,
  AvailabilityZone,
  AccessPointPort
}
import java.time.Instant
import zio.aws.elasticloadbalancing.model.primitives.SubnetId.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccessLogEnabled extends Subtype[Boolean]
    type AccessLogEnabled =
      zio.aws.elasticloadbalancing.model.primitives.AccessLogEnabled.Type
    object AccessLogInterval extends Subtype[Int]
    type AccessLogInterval =
      zio.aws.elasticloadbalancing.model.primitives.AccessLogInterval.Type
    object AccessLogPrefix extends Subtype[String]
    type AccessLogPrefix =
      zio.aws.elasticloadbalancing.model.primitives.AccessLogPrefix.Type
    object AccessPointName extends Subtype[String]
    type AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives.AccessPointName.Type
    object AccessPointPort extends Subtype[Int]
    type AccessPointPort =
      zio.aws.elasticloadbalancing.model.primitives.AccessPointPort.Type
    object AdditionalAttributeKey extends Subtype[String]
    type AdditionalAttributeKey =
      zio.aws.elasticloadbalancing.model.primitives.AdditionalAttributeKey.Type
    object AdditionalAttributeValue extends Subtype[String]
    type AdditionalAttributeValue =
      zio.aws.elasticloadbalancing.model.primitives.AdditionalAttributeValue.Type
    object AttributeName extends Subtype[String]
    type AttributeName =
      zio.aws.elasticloadbalancing.model.primitives.AttributeName.Type
    object AttributeType extends Subtype[String]
    type AttributeType =
      zio.aws.elasticloadbalancing.model.primitives.AttributeType.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue =
      zio.aws.elasticloadbalancing.model.primitives.AttributeValue.Type
    object AvailabilityZone extends Subtype[String]
    type AvailabilityZone =
      zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone.Type
    object Cardinality extends Subtype[String]
    type Cardinality =
      zio.aws.elasticloadbalancing.model.primitives.Cardinality.Type
    object ConnectionDrainingEnabled extends Subtype[Boolean]
    type ConnectionDrainingEnabled =
      zio.aws.elasticloadbalancing.model.primitives.ConnectionDrainingEnabled.Type
    object ConnectionDrainingTimeout extends Subtype[Int]
    type ConnectionDrainingTimeout =
      zio.aws.elasticloadbalancing.model.primitives.ConnectionDrainingTimeout.Type
    object CookieExpirationPeriod extends Subtype[Long]
    type CookieExpirationPeriod =
      zio.aws.elasticloadbalancing.model.primitives.CookieExpirationPeriod.Type
    object CookieName extends Subtype[String]
    type CookieName =
      zio.aws.elasticloadbalancing.model.primitives.CookieName.Type
    object CreatedTime extends Subtype[Instant]
    type CreatedTime =
      zio.aws.elasticloadbalancing.model.primitives.CreatedTime.Type
    object CrossZoneLoadBalancingEnabled extends Subtype[Boolean]
    type CrossZoneLoadBalancingEnabled =
      zio.aws.elasticloadbalancing.model.primitives.CrossZoneLoadBalancingEnabled.Type
    object DNSName extends Subtype[String]
    type DNSName = zio.aws.elasticloadbalancing.model.primitives.DNSName.Type
    object DefaultValue extends Subtype[String]
    type DefaultValue =
      zio.aws.elasticloadbalancing.model.primitives.DefaultValue.Type
    object Description extends Subtype[String]
    type Description =
      zio.aws.elasticloadbalancing.model.primitives.Description.Type
    object EndPointPort extends Subtype[Int]
    type EndPointPort =
      zio.aws.elasticloadbalancing.model.primitives.EndPointPort.Type
    object HealthCheckInterval extends Subtype[Int]
    type HealthCheckInterval =
      zio.aws.elasticloadbalancing.model.primitives.HealthCheckInterval.Type
    object HealthCheckTarget extends Subtype[String]
    type HealthCheckTarget =
      zio.aws.elasticloadbalancing.model.primitives.HealthCheckTarget.Type
    object HealthCheckTimeout extends Subtype[Int]
    type HealthCheckTimeout =
      zio.aws.elasticloadbalancing.model.primitives.HealthCheckTimeout.Type
    object HealthyThreshold extends Subtype[Int]
    type HealthyThreshold =
      zio.aws.elasticloadbalancing.model.primitives.HealthyThreshold.Type
    object IdleTimeout extends Subtype[Int]
    type IdleTimeout =
      zio.aws.elasticloadbalancing.model.primitives.IdleTimeout.Type
    object InstanceId extends Subtype[String]
    type InstanceId =
      zio.aws.elasticloadbalancing.model.primitives.InstanceId.Type
    object InstancePort extends Subtype[Int]
    type InstancePort =
      zio.aws.elasticloadbalancing.model.primitives.InstancePort.Type
    object LoadBalancerScheme extends Subtype[String]
    type LoadBalancerScheme =
      zio.aws.elasticloadbalancing.model.primitives.LoadBalancerScheme.Type
    object Marker extends Subtype[String]
    type Marker = zio.aws.elasticloadbalancing.model.primitives.Marker.Type
    object Max extends Subtype[String]
    type Max = zio.aws.elasticloadbalancing.model.primitives.Max.Type
    object Name extends Subtype[String]
    type Name = zio.aws.elasticloadbalancing.model.primitives.Name.Type
    object PageSize extends Subtype[Int]
    type PageSize = zio.aws.elasticloadbalancing.model.primitives.PageSize.Type
    object PolicyName extends Subtype[String]
    type PolicyName =
      zio.aws.elasticloadbalancing.model.primitives.PolicyName.Type
    object PolicyTypeName extends Subtype[String]
    type PolicyTypeName =
      zio.aws.elasticloadbalancing.model.primitives.PolicyTypeName.Type
    object Protocol extends Subtype[String]
    type Protocol = zio.aws.elasticloadbalancing.model.primitives.Protocol.Type
    object ReasonCode extends Subtype[String]
    type ReasonCode =
      zio.aws.elasticloadbalancing.model.primitives.ReasonCode.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName =
      zio.aws.elasticloadbalancing.model.primitives.S3BucketName.Type
    object SSLCertificateId extends Subtype[String]
    type SSLCertificateId =
      zio.aws.elasticloadbalancing.model.primitives.SSLCertificateId.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.elasticloadbalancing.model.primitives.SecurityGroupId.Type
    object SecurityGroupName extends Subtype[String]
    type SecurityGroupName =
      zio.aws.elasticloadbalancing.model.primitives.SecurityGroupName.Type
    object SecurityGroupOwnerAlias extends Subtype[String]
    type SecurityGroupOwnerAlias =
      zio.aws.elasticloadbalancing.model.primitives.SecurityGroupOwnerAlias.Type
    object State extends Subtype[String]
    type State = zio.aws.elasticloadbalancing.model.primitives.State.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.elasticloadbalancing.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.elasticloadbalancing.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.elasticloadbalancing.model.primitives.TagValue.Type
    object UnhealthyThreshold extends Subtype[Int]
    type UnhealthyThreshold =
      zio.aws.elasticloadbalancing.model.primitives.UnhealthyThreshold.Type
    object VPCId extends Subtype[String]
    type VPCId = zio.aws.elasticloadbalancing.model.primitives.VPCId.Type
  }
  type AdditionalAttributes =
    List[zio.aws.elasticloadbalancing.model.AdditionalAttribute]
  type AppCookieStickinessPolicies =
    List[zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy]
  type AvailabilityZones = List[AvailabilityZone]
  type BackendServerDescriptions =
    List[zio.aws.elasticloadbalancing.model.BackendServerDescription]
  type InstanceStates = List[zio.aws.elasticloadbalancing.model.InstanceState]
  type Instances = List[zio.aws.elasticloadbalancing.model.Instance]
  type LBCookieStickinessPolicies =
    List[zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy]
  type Limits = List[zio.aws.elasticloadbalancing.model.Limit]
  type ListenerDescriptions =
    List[zio.aws.elasticloadbalancing.model.ListenerDescription]
  type Listeners = List[zio.aws.elasticloadbalancing.model.Listener]
  type LoadBalancerDescriptions =
    List[zio.aws.elasticloadbalancing.model.LoadBalancerDescription]
  type LoadBalancerNames = List[AccessPointName]
  type LoadBalancerNamesMax20 = List[AccessPointName]
  type PolicyAttributeDescriptions =
    List[zio.aws.elasticloadbalancing.model.PolicyAttributeDescription]
  type PolicyAttributeTypeDescriptions =
    List[zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription]
  type PolicyAttributes =
    List[zio.aws.elasticloadbalancing.model.PolicyAttribute]
  type PolicyDescriptions =
    List[zio.aws.elasticloadbalancing.model.PolicyDescription]
  type PolicyNames = List[PolicyName]
  type PolicyTypeDescriptions =
    List[zio.aws.elasticloadbalancing.model.PolicyTypeDescription]
  type PolicyTypeNames = List[PolicyTypeName]
  type Ports = List[AccessPointPort]
  type SecurityGroups = List[SecurityGroupId]
  type Subnets = List[SubnetId]
  type TagDescriptions = List[zio.aws.elasticloadbalancing.model.TagDescription]
  type TagKeyList = List[zio.aws.elasticloadbalancing.model.TagKeyOnly]
  type TagList = List[zio.aws.elasticloadbalancing.model.Tag]
}
