package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceHealthResponse(
    instanceStates: Optional[
      Iterable[zio.aws.elasticloadbalancing.model.InstanceState]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse = {
    import DescribeInstanceHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse
      .builder()
      .optionallyWith(
        instanceStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceStates)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse =
      zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse(
        instanceStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceStates: Optional[
      List[zio.aws.elasticloadbalancing.model.InstanceState.ReadOnly]
    ]
    def getInstanceStates: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.InstanceState.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceStates", instanceStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse
  ) extends zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse.ReadOnly {
    override val instanceStates: Optional[
      List[zio.aws.elasticloadbalancing.model.InstanceState.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceStates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.InstanceState.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse
  ): zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse.ReadOnly =
    new Wrapper(impl)
}
