package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.InstanceId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Instance(instanceId: Optional[InstanceId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.Instance
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.Instance.ReadOnly =
    zio.aws.elasticloadbalancing.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.Instance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.Instance =
      zio.aws.elasticloadbalancing.model
        .Instance(instanceId.map(value => value))
    def instanceId: Optional[InstanceId]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Instance
  ) extends zio.aws.elasticloadbalancing.model.Instance.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.InstanceId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Instance
  ): zio.aws.elasticloadbalancing.model.Instance.ReadOnly = new Wrapper(impl)
}
