package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLoadBalancerRequest(loadBalancerName: AccessPointName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest = {
    import DeleteLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DeleteLoadBalancerRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DeleteLoadBalancerRequest
      .wrap(buildAwsValue())
}
object DeleteLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DeleteLoadBalancerRequest =
      zio.aws.elasticloadbalancing.model
        .DeleteLoadBalancerRequest(loadBalancerName)
    def loadBalancerName: AccessPointName
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest
  ) extends zio.aws.elasticloadbalancing.model.DeleteLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest
  ): zio.aws.elasticloadbalancing.model.DeleteLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
