package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{TagValue, TagKey}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: Optional[TagValue] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.Tag.ReadOnly =
    zio.aws.elasticloadbalancing.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.Tag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.Tag =
      zio.aws.elasticloadbalancing.model.Tag(key, value.map(value => value))
    def key: TagKey
    def value: Optional[TagValue]
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Tag
  ) extends zio.aws.elasticloadbalancing.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.elasticloadbalancing.model.primitives.TagKey(impl.key())
    override val value: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.TagValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Tag
  ): zio.aws.elasticloadbalancing.model.Tag.ReadOnly = new Wrapper(impl)
}
