package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterInstancesFromLoadBalancerRequest(
    loadBalancerName: AccessPointName,
    instances: Iterable[zio.aws.elasticloadbalancing.model.Instance]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest = {
    import DeregisterInstancesFromLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .instances(instances.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest
      .wrap(buildAwsValue())
}
object DeregisterInstancesFromLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest =
      zio.aws.elasticloadbalancing.model
        .DeregisterInstancesFromLoadBalancerRequest(
          loadBalancerName,
          instances.map { item =>
            item.asEditable
          }
        )
    def loadBalancerName: AccessPointName
    def instances: List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getInstances: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancing.model.Instance.ReadOnly
    ]] = ZIO.succeed(instances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest
  ) extends zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val instances
        : List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly] = impl
      .instances()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.Instance.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest
  ): zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
