package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.TagKey
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TagKeyOnly(key: Optional[TagKey] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.TagKeyOnly = {
    import TagKeyOnly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.TagKeyOnly
      .builder()
      .optionallyWith(key.map(value => TagKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.TagKeyOnly.ReadOnly =
    zio.aws.elasticloadbalancing.model.TagKeyOnly.wrap(buildAwsValue())
}
object TagKeyOnly {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.TagKeyOnly
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.TagKeyOnly =
      zio.aws.elasticloadbalancing.model.TagKeyOnly(key.map(value => value))
    def key: Optional[TagKey]
    def getKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.TagKeyOnly
  ) extends zio.aws.elasticloadbalancing.model.TagKeyOnly.ReadOnly {
    override val key: Optional[TagKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.TagKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.TagKeyOnly
  ): zio.aws.elasticloadbalancing.model.TagKeyOnly.ReadOnly = new Wrapper(impl)
}
