package zio.aws.elasticloadbalancing
import zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly
import zio.aws.elasticloadbalancing.model.{
  DeleteLoadBalancerPolicyRequest,
  DeleteLoadBalancerListenersRequest,
  DeregisterInstancesFromLoadBalancerRequest,
  DescribeInstanceHealthRequest,
  SetLoadBalancerPoliciesForBackendServerRequest,
  ApplySecurityGroupsToLoadBalancerRequest,
  DetachLoadBalancerFromSubnetsRequest,
  AttachLoadBalancerToSubnetsRequest,
  DescribeLoadBalancerAttributesRequest,
  DisableAvailabilityZonesForLoadBalancerRequest,
  AddTagsRequest,
  CreateLoadBalancerPolicyRequest,
  CreateLoadBalancerRequest,
  ModifyLoadBalancerAttributesRequest,
  RegisterInstancesWithLoadBalancerRequest,
  DescribeTagsRequest,
  DeleteLoadBalancerRequest,
  CreateLoadBalancerListenersRequest,
  CreateLbCookieStickinessPolicyRequest,
  DescribeLoadBalancersRequest,
  SetLoadBalancerListenerSslCertificateRequest,
  DescribeAccountLimitsRequest,
  ConfigureHealthCheckRequest,
  CreateAppCookieStickinessPolicyRequest,
  SetLoadBalancerPoliciesOfListenerRequest,
  RemoveTagsRequest,
  EnableAvailabilityZonesForLoadBalancerRequest,
  DescribeLoadBalancerPoliciesRequest,
  DescribeLoadBalancerPolicyTypesRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ElasticLoadBalancingMock extends Mock[ElasticLoadBalancing] {
  object DescribeTags
      extends Effect[
        DescribeTagsRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DescribeTagsResponse.ReadOnly
      ]
  object CreateLoadBalancerListeners
      extends Effect[
        CreateLoadBalancerListenersRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersResponse.ReadOnly
      ]
  object CreateLBCookieStickinessPolicy
      extends Effect[
        CreateLbCookieStickinessPolicyRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse.ReadOnly
      ]
  object DescribeLoadBalancerAttributes
      extends Effect[
        DescribeLoadBalancerAttributesRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse.ReadOnly
      ]
  object SetLoadBalancerPoliciesForBackendServer
      extends Effect[
        SetLoadBalancerPoliciesForBackendServerRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse.ReadOnly
      ]
  object DescribeInstanceHealth
      extends Effect[
        DescribeInstanceHealthRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse.ReadOnly
      ]
  object AddTags
      extends Effect[
        AddTagsRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.AddTagsResponse.ReadOnly
      ]
  object RegisterInstancesWithLoadBalancer
      extends Effect[
        RegisterInstancesWithLoadBalancerRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse.ReadOnly
      ]
  object DetachLoadBalancerFromSubnets
      extends Effect[
        DetachLoadBalancerFromSubnetsRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse.ReadOnly
      ]
  object DescribeAccountLimits
      extends Effect[
        DescribeAccountLimitsRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly
      ]
  object CreateAppCookieStickinessPolicy
      extends Effect[
        CreateAppCookieStickinessPolicyRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse.ReadOnly
      ]
  object ConfigureHealthCheck
      extends Effect[
        ConfigureHealthCheckRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse.ReadOnly
      ]
  object DeleteLoadBalancer
      extends Effect[
        DeleteLoadBalancerRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DeleteLoadBalancerResponse.ReadOnly
      ]
  object RemoveTags
      extends Effect[
        RemoveTagsRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.RemoveTagsResponse.ReadOnly
      ]
  object DescribeLoadBalancerPolicyTypes
      extends Effect[
        DescribeLoadBalancerPolicyTypesRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse.ReadOnly
      ]
  object AttachLoadBalancerToSubnets
      extends Effect[
        AttachLoadBalancerToSubnetsRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse.ReadOnly
      ]
  object ModifyLoadBalancerAttributes
      extends Effect[
        ModifyLoadBalancerAttributesRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse.ReadOnly
      ]
  object DeleteLoadBalancerListeners
      extends Effect[
        DeleteLoadBalancerListenersRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse.ReadOnly
      ]
  object CreateLoadBalancerPolicy
      extends Effect[
        CreateLoadBalancerPolicyRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse.ReadOnly
      ]
  object DescribeLoadBalancerPolicies
      extends Effect[
        DescribeLoadBalancerPoliciesRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse.ReadOnly
      ]
  object DisableAvailabilityZonesForLoadBalancer
      extends Effect[
        DisableAvailabilityZonesForLoadBalancerRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse.ReadOnly
      ]
  object DeregisterInstancesFromLoadBalancer
      extends Effect[
        DeregisterInstancesFromLoadBalancerRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse.ReadOnly
      ]
  object SetLoadBalancerPoliciesOfListener
      extends Effect[
        SetLoadBalancerPoliciesOfListenerRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse.ReadOnly
      ]
  object ApplySecurityGroupsToLoadBalancer
      extends Effect[
        ApplySecurityGroupsToLoadBalancerRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse.ReadOnly
      ]
  object CreateLoadBalancer
      extends Effect[
        CreateLoadBalancerRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse.ReadOnly
      ]
  object EnableAvailabilityZonesForLoadBalancer
      extends Effect[
        EnableAvailabilityZonesForLoadBalancerRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse.ReadOnly
      ]
  object SetLoadBalancerListenerSSLCertificate
      extends Effect[
        SetLoadBalancerListenerSslCertificateRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse.ReadOnly
      ]
  object DeleteLoadBalancerPolicy
      extends Effect[
        DeleteLoadBalancerPolicyRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse.ReadOnly
      ]
  object DescribeLoadBalancers
      extends Stream[DescribeLoadBalancersRequest, AwsError, ReadOnly]
  object DescribeLoadBalancersPaginated
      extends Effect[
        DescribeLoadBalancersRequest,
        AwsError,
        zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ElasticLoadBalancing] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ElasticLoadBalancing {
          val api: ElasticLoadBalancingAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ElasticLoadBalancing = this
          def describeTags(request: DescribeTagsRequest): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DescribeTagsResponse.ReadOnly
          ] = proxy(DescribeTags, request)
          def createLoadBalancerListeners(
              request: CreateLoadBalancerListenersRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersResponse.ReadOnly
          ] = proxy(CreateLoadBalancerListeners, request)
          def createLBCookieStickinessPolicy(
              request: CreateLbCookieStickinessPolicyRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse.ReadOnly
          ] = proxy(CreateLBCookieStickinessPolicy, request)
          def describeLoadBalancerAttributes(
              request: DescribeLoadBalancerAttributesRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse.ReadOnly
          ] = proxy(DescribeLoadBalancerAttributes, request)
          def setLoadBalancerPoliciesForBackendServer(
              request: SetLoadBalancerPoliciesForBackendServerRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse.ReadOnly
          ] = proxy(SetLoadBalancerPoliciesForBackendServer, request)
          def describeInstanceHealth(
              request: DescribeInstanceHealthRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse.ReadOnly
          ] = proxy(DescribeInstanceHealth, request)
          def addTags(request: AddTagsRequest): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.AddTagsResponse.ReadOnly
          ] = proxy(AddTags, request)
          def registerInstancesWithLoadBalancer(
              request: RegisterInstancesWithLoadBalancerRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse.ReadOnly
          ] = proxy(RegisterInstancesWithLoadBalancer, request)
          def detachLoadBalancerFromSubnets(
              request: DetachLoadBalancerFromSubnetsRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse.ReadOnly
          ] = proxy(DetachLoadBalancerFromSubnets, request)
          def describeAccountLimits(request: DescribeAccountLimitsRequest): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly
          ] = proxy(DescribeAccountLimits, request)
          def createAppCookieStickinessPolicy(
              request: CreateAppCookieStickinessPolicyRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse.ReadOnly
          ] = proxy(CreateAppCookieStickinessPolicy, request)
          def configureHealthCheck(request: ConfigureHealthCheckRequest): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse.ReadOnly
          ] = proxy(ConfigureHealthCheck, request)
          def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DeleteLoadBalancerResponse.ReadOnly
          ] = proxy(DeleteLoadBalancer, request)
          def removeTags(request: RemoveTagsRequest): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.RemoveTagsResponse.ReadOnly
          ] = proxy(RemoveTags, request)
          def describeLoadBalancerPolicyTypes(
              request: DescribeLoadBalancerPolicyTypesRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse.ReadOnly
          ] = proxy(DescribeLoadBalancerPolicyTypes, request)
          def attachLoadBalancerToSubnets(
              request: AttachLoadBalancerToSubnetsRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse.ReadOnly
          ] = proxy(AttachLoadBalancerToSubnets, request)
          def modifyLoadBalancerAttributes(
              request: ModifyLoadBalancerAttributesRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse.ReadOnly
          ] = proxy(ModifyLoadBalancerAttributes, request)
          def deleteLoadBalancerListeners(
              request: DeleteLoadBalancerListenersRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse.ReadOnly
          ] = proxy(DeleteLoadBalancerListeners, request)
          def createLoadBalancerPolicy(
              request: CreateLoadBalancerPolicyRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse.ReadOnly
          ] = proxy(CreateLoadBalancerPolicy, request)
          def describeLoadBalancerPolicies(
              request: DescribeLoadBalancerPoliciesRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse.ReadOnly
          ] = proxy(DescribeLoadBalancerPolicies, request)
          def disableAvailabilityZonesForLoadBalancer(
              request: DisableAvailabilityZonesForLoadBalancerRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse.ReadOnly
          ] = proxy(DisableAvailabilityZonesForLoadBalancer, request)
          def deregisterInstancesFromLoadBalancer(
              request: DeregisterInstancesFromLoadBalancerRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse.ReadOnly
          ] = proxy(DeregisterInstancesFromLoadBalancer, request)
          def setLoadBalancerPoliciesOfListener(
              request: SetLoadBalancerPoliciesOfListenerRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse.ReadOnly
          ] = proxy(SetLoadBalancerPoliciesOfListener, request)
          def applySecurityGroupsToLoadBalancer(
              request: ApplySecurityGroupsToLoadBalancerRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse.ReadOnly
          ] = proxy(ApplySecurityGroupsToLoadBalancer, request)
          def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse.ReadOnly
          ] = proxy(CreateLoadBalancer, request)
          def enableAvailabilityZonesForLoadBalancer(
              request: EnableAvailabilityZonesForLoadBalancerRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse.ReadOnly
          ] = proxy(EnableAvailabilityZonesForLoadBalancer, request)
          def setLoadBalancerListenerSSLCertificate(
              request: SetLoadBalancerListenerSslCertificateRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse.ReadOnly
          ] = proxy(SetLoadBalancerListenerSSLCertificate, request)
          def deleteLoadBalancerPolicy(
              request: DeleteLoadBalancerPolicyRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse.ReadOnly
          ] = proxy(DeleteLoadBalancerPolicy, request)
          def describeLoadBalancers(
              request: DescribeLoadBalancersRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(DescribeLoadBalancers, request))
          def describeLoadBalancersPaginated(
              request: DescribeLoadBalancersRequest
          ): IO[
            AwsError,
            zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse.ReadOnly
          ] = proxy(DescribeLoadBalancersPaginated, request)
        }
      }
    }
  }
}
