package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  AvailabilityZone,
  AccessPointName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableAvailabilityZonesForLoadBalancerRequest(
    loadBalancerName: AccessPointName,
    availabilityZones: Iterable[AvailabilityZone]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest = {
    import DisableAvailabilityZonesForLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .availabilityZones(availabilityZones.map { item =>
        AvailabilityZone.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest
      .wrap(buildAwsValue())
}
object DisableAvailabilityZonesForLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest =
      zio.aws.elasticloadbalancing.model
        .DisableAvailabilityZonesForLoadBalancerRequest(
          loadBalancerName,
          availabilityZones
        )
    def loadBalancerName: AccessPointName
    def availabilityZones: List[AvailabilityZone]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getAvailabilityZones: ZIO[Any, Nothing, List[AvailabilityZone]] =
      ZIO.succeed(availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest
  ) extends zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val availabilityZones: List[AvailabilityZone] = impl
      .availabilityZones()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest
  ): zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
