package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  CookieExpirationPeriod,
  PolicyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LBCookieStickinessPolicy(
    policyName: Option[PolicyName] = None,
    cookieExpirationPeriod: Option[CookieExpirationPeriod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPolicy = {
    import LBCookieStickinessPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPolicy
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        cookieExpirationPeriod.map(value =>
          CookieExpirationPeriod.unwrap(value): java.lang.Long
        )
      )(_.cookieExpirationPeriod)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy.ReadOnly =
    zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy
      .wrap(buildAwsValue())
}
object LBCookieStickinessPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy =
      zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy(
        policyName.map(value => value),
        cookieExpirationPeriod.map(value => value)
      )
    def policyName: Option[PolicyName]
    def cookieExpirationPeriod: Option[CookieExpirationPeriod]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getCookieExpirationPeriod: ZIO[Any, AwsError, CookieExpirationPeriod] =
      AwsError.unwrapOptionField(
        "cookieExpirationPeriod",
        cookieExpirationPeriod
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPolicy
  ) extends zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy.ReadOnly {
    override val policyName: Option[PolicyName] = scala
      .Option(impl.policyName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.PolicyName(value)
      )
    override val cookieExpirationPeriod: Option[CookieExpirationPeriod] = scala
      .Option(impl.cookieExpirationPeriod())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives
          .CookieExpirationPeriod(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPolicy
  ): zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy.ReadOnly =
    new Wrapper(impl)
}
