package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  PolicyTypeName,
  PolicyName,
  AccessPointName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLoadBalancerPolicyRequest(
    loadBalancerName: AccessPointName,
    policyName: PolicyName,
    policyTypeName: PolicyTypeName,
    policyAttributes: Option[
      Iterable[zio.aws.elasticloadbalancing.model.PolicyAttribute]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest = {
    import CreateLoadBalancerPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policyTypeName(PolicyTypeName.unwrap(policyTypeName): java.lang.String)
      .optionallyWith(
        policyAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest
      .wrap(buildAwsValue())
}
object CreateLoadBalancerPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest =
      zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest(
        loadBalancerName,
        policyName,
        policyTypeName,
        policyAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def loadBalancerName: AccessPointName
    def policyName: PolicyName
    def policyTypeName: PolicyTypeName
    def policyAttributes: Option[
      List[zio.aws.elasticloadbalancing.model.PolicyAttribute.ReadOnly]
    ]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicyTypeName: ZIO[Any, Nothing, PolicyTypeName] =
      ZIO.succeed(policyTypeName)
    def getPolicyAttributes: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.PolicyAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("policyAttributes", policyAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest
  ) extends zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val policyName: PolicyName =
      zio.aws.elasticloadbalancing.model.primitives
        .PolicyName(impl.policyName())
    override val policyTypeName: PolicyTypeName =
      zio.aws.elasticloadbalancing.model.primitives
        .PolicyTypeName(impl.policyTypeName())
    override val policyAttributes: Option[
      List[zio.aws.elasticloadbalancing.model.PolicyAttribute.ReadOnly]
    ] = scala
      .Option(impl.policyAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.PolicyAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest
  ): zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
