package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegisterInstancesWithLoadBalancerRequest(
    loadBalancerName: AccessPointName,
    instances: Iterable[zio.aws.elasticloadbalancing.model.Instance]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest = {
    import RegisterInstancesWithLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .instances(instances.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest
      .wrap(buildAwsValue())
}
object RegisterInstancesWithLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest =
      zio.aws.elasticloadbalancing.model
        .RegisterInstancesWithLoadBalancerRequest(
          loadBalancerName,
          instances.map { item =>
            item.asEditable
          }
        )
    def loadBalancerName: AccessPointName
    def instances: List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getInstances: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancing.model.Instance.ReadOnly
    ]] = ZIO.succeed(instances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest
  ) extends zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val instances
        : List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly] = impl
      .instances()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.Instance.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest
  ): zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
