package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  SubnetId,
  DNSName,
  AccessPointName,
  SecurityGroupId,
  LoadBalancerScheme,
  VPCId,
  AvailabilityZone,
  CreatedTime
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LoadBalancerDescription(
    loadBalancerName: Option[AccessPointName] = None,
    dnsName: Option[DNSName] = None,
    canonicalHostedZoneName: Option[DNSName] = None,
    canonicalHostedZoneNameID: Option[DNSName] = None,
    listenerDescriptions: Option[
      Iterable[zio.aws.elasticloadbalancing.model.ListenerDescription]
    ] = None,
    policies: Option[zio.aws.elasticloadbalancing.model.Policies] = None,
    backendServerDescriptions: Option[
      Iterable[zio.aws.elasticloadbalancing.model.BackendServerDescription]
    ] = None,
    availabilityZones: Option[Iterable[AvailabilityZone]] = None,
    subnets: Option[Iterable[SubnetId]] = None,
    vpcId: Option[VPCId] = None,
    instances: Option[Iterable[zio.aws.elasticloadbalancing.model.Instance]] =
      None,
    healthCheck: Option[zio.aws.elasticloadbalancing.model.HealthCheck] = None,
    sourceSecurityGroup: Option[
      zio.aws.elasticloadbalancing.model.SourceSecurityGroup
    ] = None,
    securityGroups: Option[Iterable[SecurityGroupId]] = None,
    createdTime: Option[CreatedTime] = None,
    scheme: Option[LoadBalancerScheme] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription = {
    import LoadBalancerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription
      .builder()
      .optionallyWith(
        loadBalancerName.map(value =>
          AccessPointName.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        canonicalHostedZoneName.map(value =>
          DNSName.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneName)
      .optionallyWith(
        canonicalHostedZoneNameID.map(value =>
          DNSName.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneNameID)
      .optionallyWith(
        listenerDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listenerDescriptions)
      .optionallyWith(policies.map(value => value.buildAwsValue()))(_.policies)
      .optionallyWith(
        backendServerDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backendServerDescriptions)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            AvailabilityZone.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        vpcId.map(value => VPCId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(sourceSecurityGroup.map(value => value.buildAwsValue()))(
        _.sourceSecurityGroup
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        scheme.map(value => LoadBalancerScheme.unwrap(value): java.lang.String)
      )(_.scheme)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly =
    zio.aws.elasticloadbalancing.model.LoadBalancerDescription
      .wrap(buildAwsValue())
}
object LoadBalancerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.LoadBalancerDescription =
      zio.aws.elasticloadbalancing.model.LoadBalancerDescription(
        loadBalancerName.map(value => value),
        dnsName.map(value => value),
        canonicalHostedZoneName.map(value => value),
        canonicalHostedZoneNameID.map(value => value),
        listenerDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policies.map(value => value.asEditable),
        backendServerDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZones.map(value => value),
        subnets.map(value => value),
        vpcId.map(value => value),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        healthCheck.map(value => value.asEditable),
        sourceSecurityGroup.map(value => value.asEditable),
        securityGroups.map(value => value),
        createdTime.map(value => value),
        scheme.map(value => value)
      )
    def loadBalancerName: Option[AccessPointName]
    def dnsName: Option[DNSName]
    def canonicalHostedZoneName: Option[DNSName]
    def canonicalHostedZoneNameID: Option[DNSName]
    def listenerDescriptions: Option[
      List[zio.aws.elasticloadbalancing.model.ListenerDescription.ReadOnly]
    ]
    def policies: Option[zio.aws.elasticloadbalancing.model.Policies.ReadOnly]
    def backendServerDescriptions: Option[
      List[zio.aws.elasticloadbalancing.model.BackendServerDescription.ReadOnly]
    ]
    def availabilityZones: Option[List[AvailabilityZone]]
    def subnets: Option[List[SubnetId]]
    def vpcId: Option[VPCId]
    def instances
        : Option[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]]
    def healthCheck
        : Option[zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly]
    def sourceSecurityGroup: Option[
      zio.aws.elasticloadbalancing.model.SourceSecurityGroup.ReadOnly
    ]
    def securityGroups: Option[List[SecurityGroupId]]
    def createdTime: Option[CreatedTime]
    def scheme: Option[LoadBalancerScheme]
    def getLoadBalancerName: ZIO[Any, AwsError, AccessPointName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getCanonicalHostedZoneName: ZIO[Any, AwsError, DNSName] = AwsError
      .unwrapOptionField("canonicalHostedZoneName", canonicalHostedZoneName)
    def getCanonicalHostedZoneNameID: ZIO[Any, AwsError, DNSName] = AwsError
      .unwrapOptionField("canonicalHostedZoneNameID", canonicalHostedZoneNameID)
    def getListenerDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.ListenerDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("listenerDescriptions", listenerDescriptions)
    def getPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.Policies.ReadOnly
    ] = AwsError.unwrapOptionField("policies", policies)
    def getBackendServerDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.BackendServerDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "backendServerDescriptions",
      backendServerDescriptions
    )
    def getAvailabilityZones: ZIO[Any, AwsError, List[AvailabilityZone]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSubnets: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getVpcId: ZIO[Any, AwsError, VPCId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getSourceSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.SourceSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("sourceSecurityGroup", sourceSecurityGroup)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getScheme: ZIO[Any, AwsError, LoadBalancerScheme] =
      AwsError.unwrapOptionField("scheme", scheme)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription
  ) extends zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly {
    override val loadBalancerName: Option[AccessPointName] = scala
      .Option(impl.loadBalancerName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.AccessPointName(value)
      )
    override val dnsName: Option[DNSName] = scala
      .Option(impl.dnsName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.DNSName(value)
      )
    override val canonicalHostedZoneName: Option[DNSName] = scala
      .Option(impl.canonicalHostedZoneName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.DNSName(value)
      )
    override val canonicalHostedZoneNameID: Option[DNSName] = scala
      .Option(impl.canonicalHostedZoneNameID())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.DNSName(value)
      )
    override val listenerDescriptions: Option[
      List[zio.aws.elasticloadbalancing.model.ListenerDescription.ReadOnly]
    ] = scala
      .Option(impl.listenerDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.ListenerDescription.wrap(item)
        }.toList
      )
    override val policies
        : Option[zio.aws.elasticloadbalancing.model.Policies.ReadOnly] = scala
      .Option(impl.policies())
      .map(value => zio.aws.elasticloadbalancing.model.Policies.wrap(value))
    override val backendServerDescriptions: Option[
      List[zio.aws.elasticloadbalancing.model.BackendServerDescription.ReadOnly]
    ] = scala
      .Option(impl.backendServerDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.BackendServerDescription.wrap(item)
        }.toList
      )
    override val availabilityZones: Option[List[AvailabilityZone]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone(item)
        }.toList
      )
    override val subnets: Option[List[SubnetId]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.SubnetId(item)
        }.toList
      )
    override val vpcId: Option[VPCId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.VPCId(value))
    override val instances
        : Option[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]] =
      scala
        .Option(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.Instance.wrap(item)
          }.toList
        )
    override val healthCheck
        : Option[zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly] =
      scala
        .Option(impl.healthCheck())
        .map(value =>
          zio.aws.elasticloadbalancing.model.HealthCheck.wrap(value)
        )
    override val sourceSecurityGroup: Option[
      zio.aws.elasticloadbalancing.model.SourceSecurityGroup.ReadOnly
    ] = scala
      .Option(impl.sourceSecurityGroup())
      .map(value =>
        zio.aws.elasticloadbalancing.model.SourceSecurityGroup.wrap(value)
      )
    override val securityGroups: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val createdTime: Option[CreatedTime] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.CreatedTime(value)
      )
    override val scheme: Option[LoadBalancerScheme] = scala
      .Option(impl.scheme())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.LoadBalancerScheme(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription
  ): zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly =
    new Wrapper(impl)
}
