package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancerAttributesRequest(
    loadBalancerName: AccessPointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest = {
    import DescribeLoadBalancerAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest
      .wrap(buildAwsValue())
}
object DescribeLoadBalancerAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest =
      zio.aws.elasticloadbalancing.model
        .DescribeLoadBalancerAttributesRequest(loadBalancerName)
    def loadBalancerName: AccessPointName
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest
  ) extends zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest
  ): zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
