package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableAvailabilityZonesForLoadBalancerResponse(
    availabilityZones: Option[Iterable[AvailabilityZone]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse = {
    import EnableAvailabilityZonesForLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            AvailabilityZone.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse
      .wrap(buildAwsValue())
}
object EnableAvailabilityZonesForLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse =
      zio.aws.elasticloadbalancing.model
        .EnableAvailabilityZonesForLoadBalancerResponse(
          availabilityZones.map(value => value)
        )
    def availabilityZones: Option[List[AvailabilityZone]]
    def getAvailabilityZones: ZIO[Any, AwsError, List[AvailabilityZone]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse
  ) extends zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse.ReadOnly {
    override val availabilityZones: Option[List[AvailabilityZone]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse
  ): zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse.ReadOnly =
    new Wrapper(impl)
}
