package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.DNSName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLoadBalancerResponse(dnsName: Option[DNSName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse = {
    import CreateLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse
      .builder()
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse
      .wrap(buildAwsValue())
}
object CreateLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse =
      zio.aws.elasticloadbalancing.model
        .CreateLoadBalancerResponse(dnsName.map(value => value))
    def dnsName: Option[DNSName]
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse
  ) extends zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse.ReadOnly {
    override val dnsName: Option[DNSName] = scala
      .Option(impl.dnsName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.DNSName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerResponse
  ): zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse.ReadOnly =
    new Wrapper(impl)
}
