package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoadBalancerAttributes(
    crossZoneLoadBalancing: Option[
      zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing
    ] = None,
    accessLog: Option[zio.aws.elasticloadbalancing.model.AccessLog] = None,
    connectionDraining: Option[
      zio.aws.elasticloadbalancing.model.ConnectionDraining
    ] = None,
    connectionSettings: Option[
      zio.aws.elasticloadbalancing.model.ConnectionSettings
    ] = None,
    additionalAttributes: Option[
      Iterable[zio.aws.elasticloadbalancing.model.AdditionalAttribute]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes = {
    import LoadBalancerAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes
      .builder()
      .optionallyWith(
        crossZoneLoadBalancing.map(value => value.buildAwsValue())
      )(_.crossZoneLoadBalancing)
      .optionallyWith(accessLog.map(value => value.buildAwsValue()))(
        _.accessLog
      )
      .optionallyWith(connectionDraining.map(value => value.buildAwsValue()))(
        _.connectionDraining
      )
      .optionallyWith(connectionSettings.map(value => value.buildAwsValue()))(
        _.connectionSettings
      )
      .optionallyWith(
        additionalAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly =
    zio.aws.elasticloadbalancing.model.LoadBalancerAttributes
      .wrap(buildAwsValue())
}
object LoadBalancerAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.LoadBalancerAttributes =
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes(
        crossZoneLoadBalancing.map(value => value.asEditable),
        accessLog.map(value => value.asEditable),
        connectionDraining.map(value => value.asEditable),
        connectionSettings.map(value => value.asEditable),
        additionalAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def crossZoneLoadBalancing: Option[
      zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing.ReadOnly
    ]
    def accessLog: Option[zio.aws.elasticloadbalancing.model.AccessLog.ReadOnly]
    def connectionDraining
        : Option[zio.aws.elasticloadbalancing.model.ConnectionDraining.ReadOnly]
    def connectionSettings
        : Option[zio.aws.elasticloadbalancing.model.ConnectionSettings.ReadOnly]
    def additionalAttributes: Option[
      List[zio.aws.elasticloadbalancing.model.AdditionalAttribute.ReadOnly]
    ]
    def getCrossZoneLoadBalancing: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing.ReadOnly
    ] = AwsError.unwrapOptionField(
      "crossZoneLoadBalancing",
      crossZoneLoadBalancing
    )
    def getAccessLog: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.AccessLog.ReadOnly
    ] = AwsError.unwrapOptionField("accessLog", accessLog)
    def getConnectionDraining: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.ConnectionDraining.ReadOnly
    ] = AwsError.unwrapOptionField("connectionDraining", connectionDraining)
    def getConnectionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.ConnectionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("connectionSettings", connectionSettings)
    def getAdditionalAttributes: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.AdditionalAttribute.ReadOnly
    ]] =
      AwsError.unwrapOptionField("additionalAttributes", additionalAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes
  ) extends zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly {
    override val crossZoneLoadBalancing: Option[
      zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing.ReadOnly
    ] = scala
      .Option(impl.crossZoneLoadBalancing())
      .map(value =>
        zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing.wrap(value)
      )
    override val accessLog
        : Option[zio.aws.elasticloadbalancing.model.AccessLog.ReadOnly] = scala
      .Option(impl.accessLog())
      .map(value => zio.aws.elasticloadbalancing.model.AccessLog.wrap(value))
    override val connectionDraining: Option[
      zio.aws.elasticloadbalancing.model.ConnectionDraining.ReadOnly
    ] = scala
      .Option(impl.connectionDraining())
      .map(value =>
        zio.aws.elasticloadbalancing.model.ConnectionDraining.wrap(value)
      )
    override val connectionSettings: Option[
      zio.aws.elasticloadbalancing.model.ConnectionSettings.ReadOnly
    ] = scala
      .Option(impl.connectionSettings())
      .map(value =>
        zio.aws.elasticloadbalancing.model.ConnectionSettings.wrap(value)
      )
    override val additionalAttributes: Option[
      List[zio.aws.elasticloadbalancing.model.AdditionalAttribute.ReadOnly]
    ] = scala
      .Option(impl.additionalAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.AdditionalAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerAttributes
  ): zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly =
    new Wrapper(impl)
}
