package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.Marker
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAccountLimitsResponse(
    limits: Option[Iterable[zio.aws.elasticloadbalancing.model.Limit]] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse = {
    import DescribeAccountLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
      .builder()
      .optionallyWith(
        limits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.limits)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse
      .wrap(buildAwsValue())
}
object DescribeAccountLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse =
      zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse(
        limits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def limits: Option[List[zio.aws.elasticloadbalancing.model.Limit.ReadOnly]]
    def nextMarker: Option[Marker]
    def getLimits: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.Limit.ReadOnly
    ]] = AwsError.unwrapOptionField("limits", limits)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
  ) extends zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly {
    override val limits
        : Option[List[zio.aws.elasticloadbalancing.model.Limit.ReadOnly]] =
      scala
        .Option(impl.limits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.Limit.wrap(item)
          }.toList
        )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
  ): zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
