package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{Max, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Limit(name: Option[Name] = None, max: Option[Max] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.Limit = {
    import Limit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.Limit
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(max.map(value => Max.unwrap(value): java.lang.String))(
        _.max
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.Limit.ReadOnly =
    zio.aws.elasticloadbalancing.model.Limit.wrap(buildAwsValue())
}
object Limit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.Limit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.Limit =
      zio.aws.elasticloadbalancing.model
        .Limit(name.map(value => value), max.map(value => value))
    def name: Option[Name]
    def max: Option[Max]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getMax: ZIO[Any, AwsError, Max] = AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Limit
  ) extends zio.aws.elasticloadbalancing.model.Limit.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.Name(value))
    override val max: Option[Max] = scala
      .Option(impl.max())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.Max(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Limit
  ): zio.aws.elasticloadbalancing.model.Limit.ReadOnly = new Wrapper(impl)
}
