package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{SubnetId, AccessPointName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttachLoadBalancerToSubnetsRequest(
    loadBalancerName: AccessPointName,
    subnets: Iterable[SubnetId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest = {
    import AttachLoadBalancerToSubnetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .subnets(subnets.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest
      .wrap(buildAwsValue())
}
object AttachLoadBalancerToSubnetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest =
      zio.aws.elasticloadbalancing.model
        .AttachLoadBalancerToSubnetsRequest(loadBalancerName, subnets)
    def loadBalancerName: AccessPointName
    def subnets: List[SubnetId]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getSubnets: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest
  ) extends zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val subnets: List[SubnetId] = impl
      .subnets()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.SubnetId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest
  ): zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest.ReadOnly =
    new Wrapper(impl)
}
