package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.Marker
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancersResponse(
    loadBalancerDescriptions: Option[
      Iterable[zio.aws.elasticloadbalancing.model.LoadBalancerDescription]
    ] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse = {
    import DescribeLoadBalancersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse
      .builder()
      .optionallyWith(
        loadBalancerDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancerDescriptions)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse
      .wrap(buildAwsValue())
}
object DescribeLoadBalancersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse =
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse(
        loadBalancerDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def loadBalancerDescriptions: Option[
      List[zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly]
    ]
    def nextMarker: Option[Marker]
    def getLoadBalancerDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "loadBalancerDescriptions",
      loadBalancerDescriptions
    )
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse
  ) extends zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse.ReadOnly {
    override val loadBalancerDescriptions: Option[
      List[zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly]
    ] = scala
      .Option(impl.loadBalancerDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.LoadBalancerDescription.wrap(item)
        }.toList
      )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse
  ): zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse.ReadOnly =
    new Wrapper(impl)
}
