package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancerPoliciesResponse(
    policyDescriptions: Option[
      Iterable[zio.aws.elasticloadbalancing.model.PolicyDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse = {
    import DescribeLoadBalancerPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse
      .builder()
      .optionallyWith(
        policyDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse
      .wrap(buildAwsValue())
}
object DescribeLoadBalancerPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse =
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse(
        policyDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyDescriptions: Option[
      List[zio.aws.elasticloadbalancing.model.PolicyDescription.ReadOnly]
    ]
    def getPolicyDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.PolicyDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("policyDescriptions", policyDescriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse
  ) extends zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse.ReadOnly {
    override val policyDescriptions: Option[
      List[zio.aws.elasticloadbalancing.model.PolicyDescription.ReadOnly]
    ] = scala
      .Option(impl.policyDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.PolicyDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse
  ): zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
