package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeTagsRequest(
    loadBalancerNames: Iterable[AccessPointName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest = {
    import DescribeTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest
      .builder()
      .loadBalancerNames(loadBalancerNames.map { item =>
        AccessPointName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeTagsRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeTagsRequest.wrap(buildAwsValue())
}
object DescribeTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.DescribeTagsRequest =
      zio.aws.elasticloadbalancing.model.DescribeTagsRequest(loadBalancerNames)
    def loadBalancerNames: List[AccessPointName]
    def getLoadBalancerNames: ZIO[Any, Nothing, List[AccessPointName]] =
      ZIO.succeed(loadBalancerNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest
  ) extends zio.aws.elasticloadbalancing.model.DescribeTagsRequest.ReadOnly {
    override val loadBalancerNames: List[AccessPointName] = impl
      .loadBalancerNames()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.AccessPointName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest
  ): zio.aws.elasticloadbalancing.model.DescribeTagsRequest.ReadOnly =
    new Wrapper(impl)
}
