package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeregisterInstancesFromLoadBalancerResponse(
    instances: Option[Iterable[zio.aws.elasticloadbalancing.model.Instance]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse = {
    import DeregisterInstancesFromLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse
      .wrap(buildAwsValue())
}
object DeregisterInstancesFromLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse =
      zio.aws.elasticloadbalancing.model
        .DeregisterInstancesFromLoadBalancerResponse(
          instances.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def instances
        : Option[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]]
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse
  ) extends zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse.ReadOnly {
    override val instances
        : Option[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]] =
      scala
        .Option(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.Instance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse
  ): zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse.ReadOnly =
    new Wrapper(impl)
}
