package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.SecurityGroupId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplySecurityGroupsToLoadBalancerResponse(
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse = {
    import ApplySecurityGroupsToLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse
      .builder()
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse
      .wrap(buildAwsValue())
}
object ApplySecurityGroupsToLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse =
      zio.aws.elasticloadbalancing.model
        .ApplySecurityGroupsToLoadBalancerResponse(
          securityGroups.map(value => value)
        )
    def securityGroups: Optional[List[SecurityGroupId]]
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse
  ) extends zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse.ReadOnly {
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.primitives.SecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse
  ): zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse.ReadOnly =
    new Wrapper(impl)
}
