package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.CrossZoneLoadBalancingEnabled
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CrossZoneLoadBalancing(
    enabled: CrossZoneLoadBalancingEnabled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.CrossZoneLoadBalancing = {
    import CrossZoneLoadBalancing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.CrossZoneLoadBalancing
      .builder()
      .enabled(CrossZoneLoadBalancingEnabled.unwrap(enabled): java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing.ReadOnly =
    zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing
      .wrap(buildAwsValue())
}
object CrossZoneLoadBalancing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.CrossZoneLoadBalancing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing =
      zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing(enabled)
    def enabled: CrossZoneLoadBalancingEnabled
    def getEnabled: ZIO[Any, Nothing, CrossZoneLoadBalancingEnabled] =
      ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CrossZoneLoadBalancing
  ) extends zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing.ReadOnly {
    override val enabled: CrossZoneLoadBalancingEnabled =
      zio.aws.elasticloadbalancing.model.primitives
        .CrossZoneLoadBalancingEnabled(impl.enabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CrossZoneLoadBalancing
  ): zio.aws.elasticloadbalancing.model.CrossZoneLoadBalancing.ReadOnly =
    new Wrapper(impl)
}
