package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveTagsRequest(
    loadBalancerNames: Iterable[AccessPointName],
    tags: Iterable[zio.aws.elasticloadbalancing.model.TagKeyOnly]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest = {
    import RemoveTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest
      .builder()
      .loadBalancerNames(loadBalancerNames.map { item =>
        AccessPointName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.RemoveTagsRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.RemoveTagsRequest.wrap(buildAwsValue())
}
object RemoveTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.RemoveTagsRequest =
      zio.aws.elasticloadbalancing.model.RemoveTagsRequest(
        loadBalancerNames,
        tags.map { item =>
          item.asEditable
        }
      )
    def loadBalancerNames: List[AccessPointName]
    def tags: List[zio.aws.elasticloadbalancing.model.TagKeyOnly.ReadOnly]
    def getLoadBalancerNames: ZIO[Any, Nothing, List[AccessPointName]] =
      ZIO.succeed(loadBalancerNames)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancing.model.TagKeyOnly.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest
  ) extends zio.aws.elasticloadbalancing.model.RemoveTagsRequest.ReadOnly {
    override val loadBalancerNames: List[AccessPointName] = impl
      .loadBalancerNames()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.AccessPointName(item)
      }
      .toList
    override val tags
        : List[zio.aws.elasticloadbalancing.model.TagKeyOnly.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.TagKeyOnly.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest
  ): zio.aws.elasticloadbalancing.model.RemoveTagsRequest.ReadOnly =
    new Wrapper(impl)
}
