package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyLoadBalancerAttributesResponse(
    loadBalancerName: Optional[AccessPointName] = Optional.Absent,
    loadBalancerAttributes: Optional[
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse = {
    import ModifyLoadBalancerAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse
      .builder()
      .optionallyWith(
        loadBalancerName.map(value =>
          AccessPointName.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(
        loadBalancerAttributes.map(value => value.buildAwsValue())
      )(_.loadBalancerAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse
      .wrap(buildAwsValue())
}
object ModifyLoadBalancerAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse =
      zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse(
        loadBalancerName.map(value => value),
        loadBalancerAttributes.map(value => value.asEditable)
      )
    def loadBalancerName: Optional[AccessPointName]
    def loadBalancerAttributes: Optional[
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly
    ]
    def getLoadBalancerName: ZIO[Any, AwsError, AccessPointName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getLoadBalancerAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "loadBalancerAttributes",
      loadBalancerAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse
  ) extends zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse.ReadOnly {
    override val loadBalancerName: Optional[AccessPointName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerName())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives.AccessPointName(value)
        )
    override val loadBalancerAttributes: Optional[
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerAttributes())
      .map(value =>
        zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse
  ): zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
